/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.LogWriter;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.entity.data.DropSet;

public class DropsTemplate {
    public final Map<Integer, Map<Integer, DropSet>> groups = new TreeMap<Integer, Map<Integer, DropSet>>();
    private boolean allDropsFromGroup = false;
    private final Random rnd = new Random();

    public DropsTemplate() {
        this.groups.put(0, new TreeMap());
    }

    public DropsTemplate(NBTTagCompound nbtTemplate) {
        this();
        this.load(nbtTemplate);
    }

    public DropSet addDropItem(int id, IItemStack item, double chance) {
        if (!this.groups.containsKey(id)) {
            id = this.groups.size();
            this.groups.put(id, new TreeMap());
        }
        DropSet ds = new DropSet(null);
        ds.item = item;
        ds.setChance(chance);
        ds.pos = this.groups.get(id).size();
        this.groups.get(id).put(ds.pos, ds);
        return ds;
    }

    public List<DropSet> getDrops() {
        ArrayList<DropSet> allDrops = new ArrayList<DropSet>();
        for (int groupId : this.groups.keySet()) {
            ArrayList<DropSet> preList = new ArrayList<DropSet>(this.groups.get(groupId).values());
            if (preList.isEmpty()) continue;
            if (this.allDropsFromGroup) {
                allDrops.addAll(preList);
                continue;
            }
            allDrops.add(preList.get(this.rnd.nextInt(preList.size())));
        }
        return allDrops;
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound nbtTemplate = new NBTTagCompound();
        nbtTemplate.func_74757_a("DropType", this.allDropsFromGroup);
        for (int id : this.groups.keySet()) {
            NBTTagList list = new NBTTagList();
            for (DropSet ds : this.groups.get(id).values()) {
                list.func_74742_a((NBTBase)ds.getNBT());
            }
            nbtTemplate.func_74782_a("Group_" + id, (NBTBase)list);
        }
        return nbtTemplate;
    }

    public void load(NBTTagCompound nbtTemplate) {
        if (nbtTemplate.func_150297_b("DropType", 3)) {
            this.allDropsFromGroup = nbtTemplate.func_74762_e("DropType") == 3;
        } else if (nbtTemplate.func_150297_b("DropType", 1)) {
            this.allDropsFromGroup = nbtTemplate.func_74767_n("DropType");
        }
        this.groups.clear();
        Set keys = nbtTemplate.func_150296_c();
        for (String groupId : keys) {
            if (groupId.indexOf("Group_") != 0) continue;
            int id = -1;
            try {
                id = Integer.parseInt(groupId.replace("Group_", ""));
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            if (id < 0) continue;
            for (int j = 0; j < nbtTemplate.func_150295_c(groupId, 10).func_74745_c(); ++j) {
                DropSet ds = new DropSet(null);
                ds.load(nbtTemplate.func_150295_c(groupId, 10).func_150305_b(j));
                ds.pos = j;
                if (!this.groups.containsKey(id)) {
                    this.groups.put(id, new TreeMap());
                }
                this.groups.get(id).put(ds.pos, ds);
            }
        }
    }

    public void removeDrop(int groupId, int slot) {
        if (!this.groups.containsKey(groupId) || !this.groups.get(groupId).containsKey(slot)) {
            return;
        }
        if (this.groups.get(groupId).remove(slot) != null) {
            int j = 0;
            for (int s : this.groups.get(groupId).keySet()) {
                this.groups.get((Object)Integer.valueOf((int)groupId)).get((Object)Integer.valueOf((int)s)).pos = j++;
            }
        }
    }

    public void removeGroup(int groupId) {
        if (!this.groups.containsKey(groupId)) {
            return;
        }
        this.groups.remove(groupId);
        TreeMap<Integer, Map<Integer, DropSet>> newGroups = new TreeMap<Integer, Map<Integer, DropSet>>();
        int j = 0;
        for (int gId : this.groups.keySet()) {
            if (gId == groupId) continue;
            newGroups.put(j, this.groups.get(gId));
            ++j;
        }
        this.groups.clear();
        this.groups.putAll(newGroups);
    }

    public static DropsTemplate from(DropsTemplate dropTemplate) {
        DropsTemplate dt = new DropsTemplate();
        if (dropTemplate != null) {
            dt.load(dropTemplate.getNBT());
        }
        return dt;
    }
}

